<x-kasir.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.css">
    </x-slot:head>


    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">

            </div><!-- /.container-fluid -->
        </div>

        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12">
                        <x-message></x-message>
                        <div class="card card-danger card-outline">

                            <div class="card-header">
                                <form class="form-inline float-right">
                                    <input class="form-control mr-sm-2" type="search" placeholder="Search"
                                        aria-label="Search" name="cari">
                                    <button class="btn btn-primary " type="submit"> <i class="fa fa-search mr-2"></i>
                                        Cari!</button>
                                </form>
                                <h3 class="card-title"><i class="fa fa-server text-danger"></i> {{ $data['page'] }}</h3>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-hover myTable tab ">
                                    <thead>
                                        <tr>
                                            <th width="5%">No</th>
                                            <th>No Transaksi</th>
                                            <th>Atas Nama</th>
                                            <th>Tanggal</th>
                                            <th>Jumlah</th>
                                            <th>diskon</th>
                                            <th>ongkir</th>
                                            <th>Total</th>
                                            <th>Sts. Pembayaran</th>
                                            <th>Sts. Antar</th>
                                            <th>Sts. Diterima</th>

                                            <th>Opsi</th>
                                        </tr>
                                    </thead>
                                    <tbody id="view">
                                        @forelse ($order as $o)
                                            <tr>
                                                <td class="text-center">{{ $no++ }}</td>

                                                <td>{{ $o->transaksi->kd_transaksi }}</td>
                                                <td>{{ $o->transaksi->member->nm_member }}</td>
                                                <td>{{ tgl_time($o->transaksi->created_at) }}</td>
                                                <td class="text-right">
                                                    {{ number_format($o->transaksi->jumlah, 0, ',', '.') }}</td>
                                                <td class="text-right">
                                                    {{ number_format($o->transaksi->diskon, 0, ',', '.') }}</td>
                                                <td class="text-right">
                                                    {{ number_format($o->transaksi->ongkir, 0, ',', '.') }}</td>
                                                <td class="text-right">
                                                    {{ number_format($o->transaksi->total, 0, ',', '.') }}</td>
                                                <td class="text-center">
                                                    @if ($o->sts_transfer == 'N')
                                                        @php
                                                            $tgl = date('Y-m-d H:i:s');
                                                            $tgl_expired = strtotime($o->expired);
                                                            $tgl_sekarang = strtotime($tgl);
                                                            $expired = $tgl_sekarang - $tgl_expired;
                                                        @endphp
                                                        @if ($expired > 0)
                                                            <span class="badge badge-dark pl-5 pr-5 p-2">Expired</span>
                                                        @else
                                                            <span class="badge badge-danger ">Menunggu
                                                                Pembayaran</span>
                                                        @endif
                                                    @elseif($o->sts_transfer == 'T')
                                                        <a class="btn btn-warning btn-sm konfirmasi"
                                                            data-id="{{ $o->id }}">
                                                            <i class="fa fa-hand-pointer mr-2"></i>Konfirmasi
                                                            Pembayaran</a>
                                                    @elseif($o->sts_transfer == 'Y')
                                                        <span class="badge badge-success ">Sudah Dibayar</span>
                                                    @endif


                                                </td>
                                                <td class="text-center">
                                                    @if ($o->transaksi->sts_antar == 'N')
                                                        <span class="badge badge-warning ">Diambil ditoko</span>
                                                    @else
                                                        {{-- @if (kurir($o->transaksi->id) == null) --}}
                                                        @if ($o->transaksi->kurir == null)
                                                            @if ($o->sts_transfer == 'Y')
                                                                <button class="btn btn-sm btn-danger kurir"
                                                                    data-nm="{{ $o->transaksi->member->nm_member }}"
                                                                    data-ok="{{ $o->transaksi->member->ongkirmember->alamat }}"
                                                                    data-kd="#{{ $o->transaksi->kd_transaksi }}"
                                                                    data-id="{{ $o->transaksi->id }}">Pilih Kurir
                                                                    <i class="fa fa-truck ml-2"></i>
                                                                </button>
                                                            @else
                                                                -
                                                            @endif
                                                        @else
                                                            <span class="badge badge-primary ">Diantar
                                                                {{ $o->transaksi->kurir->karyawan->nm_karyawan }}</span>
                                                        @endif
                                                    @endif
                                                </td>

                                                <td class="text-center">
                                                    @if ($o->transaksi->sts_antar == 'N')
                                                        @if ($o->sts_transfer == 'Y')
                                                            @if ($o->tgl_diterima == null)
                                                                <button class="btn btn-sm btn-danger diterima"
                                                                    data-id="{{ $o->id }}"
                                                                    data-kd="{{ $o->transaksi->kd_transaksi }}"
                                                                    data-nm="{{ $o->transaksi->member->nm_member }}">
                                                                    <i class="fa fa-hand-pointer mr-2"></i> Update Sts.
                                                                    Diterima</button>
                                                            @else
                                                                <span class="badge badge-success ">Diterima
                                                                    : {{ tgl_inf($o->tgl_diterima) }}</span>
                                                            @endif
                                                        @else
                                                            -
                                                        @endif
                                                    @else
                                                        @if ($o->transaksi->kurir == null)
                                                            -
                                                        @else
                                                            @if ($o->tgl_diterima == null)
                                                                <button class="btn btn-sm btn-danger diterima"
                                                                    data-id="{{ $o->id }}"
                                                                    data-kd="{{ $o->transaksi->kd_transaksi }}"
                                                                    data-nm="{{ $o->transaksi->member->nm_member }}">
                                                                    <i class="fa fa-hand-pointer mr-2"></i> Update Sts.
                                                                    Diterima</button>
                                                            @else
                                                                <span class="badge badge-success ">Diterima
                                                                    : {{ tgl_inf($o->tgl_diterima) }}</span>
                                                            @endif
                                                        @endif
                                                    @endif
                                                </td>

                                                <td class="text-center">
                                                    <button class="btn btn-info btn-sm detail"
                                                        data-id="{{ $o->transaksi->id }}"><i
                                                            class="fa fa-search mr-2"></i> Detail</button>
                                                    @if ($o->sts_transfer != 'Y')
                                                        <button class="btn btn-danger btn-sm hapus"
                                                            data-kd="{{ $o->transaksi->kd_transaksi }}"
                                                            data-id="{{ $o->transaksi->id }}"
                                                            data-nm="{{ $o->transaksi->member->nm_member }}">
                                                            <i class="fa fa-trash mr-2"></i> Hapus</button>
                                                    @endif
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="20" class="text-center">Data masih kosong</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                {{ $order->links('components.admin.pagination') }}
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->

                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
    </div>
    <!-- /.content -->


    {{-- data Transfer --}}
    <div class="modal fade" id="mtransfer">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-danger ">
                    Data transfer
                </div>
                <form action="konfirmasi-pembayaran" method="post">
                    @csrf
                    <input type="hidden" name="id" id="idt">
                    <div class="modal-body" id="tf">

                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary "><i class="fa fa-money mr-2"></i>
                            Konfirmasi
                            Pembayaran</button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    {{-- pilih kurir --}}
    <div class="modal fade" id="mkurir">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-danger ">
                    Pilih Kurir
                </div>
                <div class="modal-body">
                    <input type="hidden" name="" id="kid">
                    <label for="">No Transaksi</label>
                    <input type="text" name="" id="knp" class="form-control" readonly>
                    <label for="">Atas nama</label>
                    <input type="text" name="" id="knm" class="form-control" readonly>
                    <label for="">Alamat Tujuan</label>
                    <textarea name="" id="alamtk" class="form-control" readonly></textarea>
                    <hr>
                    <label for="">Pilih Kurir</label>
                    <select name="" id="karyawan" class="form-control">
                        <option value="">Pilih</option>
                        @forelse ($karyawan as $k)
                            <option value="{{ $k->id }}">{{ $k->nm_karyawan }}</option>
                        @empty
                        @endforelse
                    </select>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary update_pengiriman"><i class="fa fa-truck mr-2"></i>
                        Update
                        Pengiriman</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    {{-- detail  --}}
    <div class="modal fade" id="detail">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header bg-danger ">
                    Detail Order
                </div>
                <div class="modal-body" id="vdetailorder">

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.js"></script>
        <script>
            $('#view').on('click', '.konfirmasi', function() {
                var token = $("meta[name='csrf-token']").attr("content");
                var id = $(this).attr('data-id');
                $.ajax({
                    type: 'POST',
                    url: 'cek-tansfer',
                    data: {
                        id: id,
                        _token: token,
                    },
                    success: function(data) {
                        $('#tf').html(data);
                        $('#idt').val(id);
                        $('#mtransfer').modal('show');
                    }
                });

            })

            $("#view").on("click", ".kurir", function() {
                var id = $(this).attr("data-id");
                var nm = $(this).attr("data-nm");
                var kd = $(this).attr("data-kd");
                var ok = $(this).attr("data-ok");
                $("#mkurir").modal("show");
                $("#kid").val(id);
                $("#knm").val(nm);
                $("#knp").val(kd);
                $("#alamtk").val(ok);
            });

            $("#mkurir").on("click", ".update_pengiriman", function() {
                var token = $("meta[name='csrf-token']").attr("content");
                var id = $("#kid").val();
                var karyawan = $("#karyawan").val();
                if (karyawan == "") {
                    toastr.error("Silhkan pilih kurir terlebih dahulu.");
                    $("#karyawan").focus();
                } else {
                    $.ajax({
                        type: "post",
                        url: "update-kurir",
                        data: {
                            id: id,
                            karyawan: karyawan,
                            _token: token,
                        },
                        beforeSend: function() {
                            $(this).html(
                                '<i class="fas fa-spinner fa-spin"></i> Proses..'
                            );
                            $(this).attr("disabled", true);
                        },
                        success: function(data) {
                            Swal.fire({
                                icon: "success",
                                title: "Berhasil",
                                text: "Pengiriman barang berhasil disimpan!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    document.location.href = "";
                                }
                            });
                        },
                    });
                }
            });

            $("#view").on("click", ".diterima", function() {
                var id = $(this).attr("data-id");
                var nm = $(this).attr("data-nm");
                var kd = $(this).attr("data-kd");
                Swal.fire({
                    title: "Pastikan dengan benar!",
                    text: "Orderan dengan No Transaksi ( #" + kd +
                        " ) atas nama " + nm + " sudah menerima barang pesanan!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Ya, Benar!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.location.href = "update-diterima/" + id;
                    }
                });
            });


            $("#view").on("click", ".detail", function() {
                var token = $("meta[name='csrf-token']").attr("content");
                var id = $(this).attr("data-id");
                $.ajax({
                    type: "POST",
                    url: "detail-penjualan",
                    data: {
                        id: id,
                        _token: token,
                    },
                    success: function(data) {
                        $("#detail").modal("show");
                        $("#vdetailorder").html(data);
                    },
                });
            });

            $("#view").on("click", ".hapus", function() {
                var token = $("meta[name='csrf-token']").attr("content");
                var id = $(this).attr("data-id");
                var nm = $(this).attr('data-nm');
                var kd = $(this).attr('data-kd');

                Swal.fire({
                    title: "Apa anda yakin?",
                    text: "Orderan dengan No Transaksi ( #" + kd +
                        " ) atas nama " + nm + " Akan dihapus!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Ya, Hapus!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.location.href = "delete-order/" + id;
                    }
                });
            });
        </script>
    </x-slot:foot>
</x-kasir.contents>
